// List of all features and their plan assignments
// This config can be updated by admin endpoints

export const FEATURES = [
  {
    key: 'ai_assistant',
    name: 'AI Assistant',
    description: 'Access to AI-powered design and business assistant',
    plans: ['Pro', 'Elite', 'Team']
  },
  {
    key: 'inventory_management',
    name: 'Inventory Management',
    description: 'Track and manage inventory',
    plans: ['Pro', 'Elite', 'Team']
  },
  {
    key: 'team_collaboration',
    name: 'Team Collaboration',
    description: 'Invite staff and manage team roles',
    plans: ['Elite', 'Team']
  },
  {
    key: 'priority_support',
    name: 'Priority Support',
    description: 'Get access to priority customer support',
    plans: ['Elite', 'Team']
  },
  {
    key: 'custom_branding',
    name: 'Custom Branding',
    description: 'Customize app with your own brand',
    plans: ['Team']
  },
  {
    key: 'consultation_forms',
    name: 'Consultation Forms',
    description: 'Create and manage customer consultation forms',
    plans: ['Pro', 'Elite', 'Team']
  },
  {
    key: 'paid_consultations',
    name: 'Paid Consultations',
    description: 'Charge for consultation services',
    plans: ['Elite', 'Team']
  },
  {
    key: 'manage_sellers',
    name: 'Seller Management',
    description: 'Manage seller accounts and inventory',
    plans: ['Admin', 'Staff', 'Supervendor']
  },
  {
    key: 'allow_debug_tools',
    name: 'Debug Tools',
    description: 'Access to diagnostic and testing endpoints',
    plans: ['Superadmin', 'QA', 'Staff']
  },
  {
    key: 'enable_api_test_suite',
    name: 'API Test Suite',
    description: 'Enable automated testing scripts',
    plans: ['Superadmin', 'QA']
  }
  // Add more features as needed
];

// Helper to get features for a plan
export function getFeaturesForPlan(planName: string) {
  return FEATURES.filter(f => f.plans.includes(planName)).map(f => f.key);
}

// Helper to get all feature keys
export function getAllFeatureKeys() {
  return FEATURES.map(f => f.key);
} 